# Vektor Guvenlik Sistemleri WordPress Temasi

Bu tema, Vektor Guvenlik Sistemleri icin ozel olarak tasarlanmis modern bir WordPress temasidir.

## Kurulum Adimlari

### 1. WordPress Hosting Hazirlayin

Oncelikle bir WordPress hosting'e ihtiyaciniz var. Asagidaki hostinglerden birini kullanabilirsiniz:

- **Turhost** (https://www.turhost.com)
- **Natro** (https://www.natro.com)
- **Hostinger** (https://www.hostinger.com.tr)
- Herhangi bir WordPress destekli hosting

### 2. WordPress Yukleyin

Hosting saglayicinizin kontrol panelinden (genellikle cPanel) WordPress'i kurun. Cogu hosting saglayici "WordPress Otomatik Yukleyici" sunar.

### 3. Temayı Yukleyin

#### Yontem 1: WordPress Kontrol Panelinden

1. WordPress yonetim panelinize giris yapin (genellikle: `siteniz.com/wp-admin`)
2. Sol menuden **Gorunum > Temalar** bolumune gidin
3. **Yeni Ekle** butonuna tiklayin
4. **Tema Yukle** butonuna tiklayin
5. `wordpress-theme` klasorunu ZIP dosyasi olarak sikistirin
6. ZIP dosyasini yukleyin ve **Etkinlestir** butonuna tiklayin

#### Yontem 2: FTP ile

1. Bir FTP programi kullanarak (FileZilla gibi) hosting'inize baglanin
2. `wp-content/themes/` klasorune gidin
3. `wordpress-theme` klasorunu buraya yukleyin
4. WordPress yonetim panelinden **Gorunum > Temalar** bolumune gidip temayi etkinlestirin

### 4. Tema Ayarlarini Yapin

#### Logo Yukleyin

1. **Gorunum > Ozellestir > Site Kimliği** bolumune gidin
2. Logo yukleyin

#### Iletisim Bilgilerini Guncelleyin

1. **Gorunum > Ozellestir > Iletisim Bilgileri** bolumune gidin
2. Telefon numaralarinizi, e-posta ve adresinizi girin

#### Menuleri Olusturun

1. **Gorunum > Menuler** bolumune gidin
2. Yeni bir menu olusturun ve asagidaki sayfalari ekleyin:
   - Ana Sayfa
   - Urunler (Hizmetler arsiv sayfasi)
   - Blog
   - Hakkimizda
   - Referanslar
   - Iletisim
3. Menuyu "Ana Menu" konumuna atayin

### 5. Sayfalar Olusturun

#### Ana Sayfa

1. **Sayfalar > Yeni Ekle** bolumune gidin
2. Baslik: "Ana Sayfa"
3. **Yayinla** butonuna tiklayin
4. **Ayarlar > Okuma** bolumunden bu sayfayi "Ana sayfa" olarak atayin

#### Iletisim Sayfasi

1. **Sayfalar > Yeni Ekle** bolumune gidin
2. Baslik: "Iletisim"
3. Sag taraftan **Sayfa Ozellikleri > Sablon** bolumunden "Iletisim Sayfasi" sablonunu secin
4. **Yayinla** butonuna tiklayin

#### Diger Sayfalar

Asagidaki sayfalari da olusturun:
- Hakkimizda
- Blog (Arsiv sayfasi olacak)

### 6. Hizmetler (Urunler) Ekleyin

1. Sol menuden **Hizmetler > Yeni Ekle** bolumune gidin
2. Asagidaki hizmetleri ekleyin:
   - Alarm Sistemleri
   - Yangin Sistemleri
   - Gecis Kontrol
   - Arac Takip
   - Diyafon & Akilli Ev
   - Kamera Sistemleri
3. Her hizmet icin:
   - Baslik girin
   - Aciklama yazin
   - Gorsel yukleyin (Onerilen boyut: 400x300px)
   - Sag taraftan "Hizmet Iconu" alanina ikon ismi girin (Bell, Camera, Lock, Flame, Phone, Car)

### 7. Blog Yazilari Ekleyin

1. **Yazilar > Yeni Ekle** bolumune gidin
2. Blog yazinizi yazin
3. One cikan gorsel yukleyin
4. Kategori ve etiket ekleyin
5. **Yayinla** butonuna tiklayin

### 8. Referanslar Ekleyin

1. Sol menuden **Referanslar > Yeni Ekle** bolumune gidin
2. Referans adini girin
3. Logo veya gorsel yukleyin
4. **Yayinla** butonuna tiklayin

## Tema Ozellikleri

### Ozel Post Tipleri

- **Hizmetler (Services)**: Sundugunuz hizmetleri gostermek icin
- **Referanslar (References)**: Musteri logolarini gostermek icin

### Widget Alanlari

Tema 4 adet footer widget alani icerir:
- Footer 1: Logo ve sosyal medya
- Footer 2: Hizli linkler
- Footer 3: Urunler
- Footer 4: Iletisim bilgileri

### Shortcode'lar

#### Iletisim Formu

Herhangi bir sayfaya iletisim formu eklemek icin:

```
[vektor_contact_form]
```

### Ozel Sayfa Sablonlari

- **Iletisim Sayfasi**: `page-iletisim.php` - Iletisim formu ve bilgiler icin

## E-posta Ayarlari

Iletisim formunun calisabilmesi icin WordPress e-posta ayarlarinin dogru yapilmasi gerekir. Cogu hosting saglayicisi otomatik olarak bu ayarlari yapar, ancak sorun yasarsaniz bir SMTP eklentisi (WP Mail SMTP gibi) kullanabilirsiniz.

## Gereksinimler

- WordPress 5.0 veya uzeri
- PHP 7.4 veya uzeri
- MySQL 5.6 veya uzeri

## Destek ve Guncelleme

Tema herhangi bir sorunla karsilasirsiniz veya yeni ozellik eklemek isterseniz, tema dosyalarini duzenleyebilir veya bir WordPress gelistiricisinden yardim alabilirsiniz.

## Onemli Notlar

1. **Gorseller**: Tema Pexels'den ucretsiz stok fotograflar kullanir. Kendi gorsellerinizi yukleyebilirsiniz.

2. **Renk Temasi**: Tema kirmizi (#dc2626) renk temasini kullanir. Bu rengi degistirmek icin `style.css` dosyasindaki tum `#dc2626` degerlerini degistirebilirsiniz.

3. **Yedekleme**: Tema uzerinde degisiklik yapmadan once mutlaka yedek alin.

4. **Guvenlik**: WordPress'i ve eklentileri duzenli olarak guncelleyin.

5. **SSL Sertifikasi**: Sitenizin SSL sertifikasi olduguna emin olun (https://).

## Yardim Gerekiyorsa

WordPress toplulugundan yardim almak icin:
- WordPress Turkiye Forum: https://forum.wordpress.org.tr
- WordPress.org Dokumantasyon: https://wordpress.org/support

## Lisans

Bu tema GNU General Public License v2 veya uzeri ile lisanslanmistir.
