<?php get_header(); ?>

<div style="padding-top: 100px; padding-bottom: 60px;">
    <div class="container">
        <div class="section-title">
            <h1><?php
                if (is_post_type_archive('service')) {
                    echo 'Hizmetlerimiz';
                } elseif (is_post_type_archive('reference')) {
                    echo 'Referanslarimiz';
                } else {
                    the_archive_title();
                }
                ?></h1>
            <?php the_archive_description('<p>', '</p>'); ?>
        </div>

        <?php if (is_post_type_archive('service')) : ?>
            <div class="services-grid">
                <?php
                while (have_posts()) : the_post();
                    ?>
                    <a href="<?php the_permalink(); ?>" class="service-card">
                        <div class="service-card-image">
                            <?php
                            if (has_post_thumbnail()) {
                                the_post_thumbnail('service-thumb');
                            } else {
                                echo '<img src="https://images.pexels.com/photos/60504/security-protection-anti-virus-software-60504.jpeg?auto=compress&cs=tinysrgb&w=400" alt="' . get_the_title() . '">';
                            }
                            ?>
                        </div>
                        <div class="service-card-content">
                            <h3><?php the_title(); ?></h3>
                            <p><?php echo wp_trim_words(get_the_excerpt(), 15); ?></p>
                        </div>
                    </a>
                    <?php
                endwhile;
                ?>
            </div>

        <?php elseif (is_post_type_archive('reference')) : ?>
            <div class="services-grid">
                <?php
                while (have_posts()) : the_post();
                    ?>
                    <div class="service-card">
                        <div class="service-card-image">
                            <?php
                            if (has_post_thumbnail()) {
                                the_post_thumbnail('service-thumb');
                            } else {
                                echo '<img src="https://images.pexels.com/photos/3184465/pexels-photo-3184465.jpeg?auto=compress&cs=tinysrgb&w=400" alt="' . get_the_title() . '">';
                            }
                            ?>
                        </div>
                        <div class="service-card-content">
                            <h3><?php the_title(); ?></h3>
                        </div>
                    </div>
                    <?php
                endwhile;
                ?>
            </div>

        <?php else : ?>
            <div class="blog-grid">
                <?php
                while (have_posts()) : the_post();
                    ?>
                    <article class="blog-card">
                        <div class="blog-card-image">
                            <a href="<?php the_permalink(); ?>">
                                <?php
                                if (has_post_thumbnail()) {
                                    the_post_thumbnail('blog-thumb');
                                } else {
                                    echo '<img src="https://images.pexels.com/photos/430208/pexels-photo-430208.jpeg?auto=compress&cs=tinysrgb&w=600" alt="' . get_the_title() . '">';
                                }
                                ?>
                            </a>
                        </div>
                        <div class="blog-card-content">
                            <div class="blog-meta">
                                <span><?php echo get_the_date(); ?></span>
                                <span><?php the_category(', '); ?></span>
                            </div>
                            <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                            <div class="excerpt"><?php the_excerpt(); ?></div>
                            <a href="<?php the_permalink(); ?>" class="btn btn-primary">Devamini Oku</a>
                        </div>
                    </article>
                    <?php
                endwhile;
                ?>
            </div>
        <?php endif; ?>

        <div style="margin-top: 40px; text-align: center;">
            <?php
            the_posts_pagination(array(
                'mid_size' => 2,
                'prev_text' => '← Onceki',
                'next_text' => 'Sonraki →',
            ));
            ?>
        </div>
    </div>
</div>

<?php get_footer(); ?>
