<footer class="site-footer">
    <div class="container">
        <div class="footer-grid">
            <?php if (is_active_sidebar('footer-1')) : ?>
                <div class="footer-widget">
                    <div style="margin-bottom: 20px;">
                        <?php if (has_custom_logo()) : ?>
                            <?php the_custom_logo(); ?>
                        <?php else : ?>
                            <h2 style="color: #dc2626; font-size: 24px;">VEKTOR</h2>
                            <p style="font-size: 12px; color: #999;">Guvenlik Sistemleri</p>
                        <?php endif; ?>
                    </div>
                    <p>2016 yilindan bu yana guvenlik sektorunde profesyonel cozumler sunuyoruz. Bolgemizde guvenilir hizmet.</p>

                    <div class="social-links">
                        <a href="https://wa.me/<?php echo esc_attr(get_theme_mod('whatsapp_number', '905426881924')); ?>" target="_blank">
                            <svg viewBox="0 0 24 24" fill="currentColor" style="width:20px;height:20px">
                                <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413z"/>
                            </svg>
                        </a>
                        <a href="https://instagram.com/vektorguvenliksistemleri" target="_blank">
                            <svg viewBox="0 0 24 24" fill="currentColor" style="width:20px;height:20px">
                                <path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zM12 0C8.741 0 8.333.014 7.053.072 2.695.272.273 2.69.073 7.052.014 8.333 0 8.741 0 12c0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98C8.333 23.986 8.741 24 12 24c3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98C15.668.014 15.259 0 12 0zm0 5.838a6.162 6.162 0 100 12.324 6.162 6.162 0 000-12.324zM12 16a4 4 0 110-8 4 4 0 010 8zm6.406-11.845a1.44 1.44 0 100 2.881 1.44 1.44 0 000-2.881z"/>
                            </svg>
                        </a>
                        <a href="https://facebook.com/vektorguvenliksistemleri" target="_blank">
                            <svg viewBox="0 0 24 24" fill="currentColor" style="width:20px;height:20px">
                                <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                            </svg>
                        </a>
                    </div>
                </div>
            <?php endif; ?>

            <?php if (is_active_sidebar('footer-2')) : ?>
                <?php dynamic_sidebar('footer-2'); ?>
            <?php else : ?>
                <div class="footer-widget">
                    <h3>Hizli Linkler</h3>
                    <ul>
                        <li><a href="<?php echo esc_url(home_url('/')); ?>">Ana Sayfa</a></li>
                        <li><a href="<?php echo esc_url(home_url('/hakkimizda')); ?>">Hakkimizda</a></li>
                        <li><a href="<?php echo esc_url(home_url('/referanslar')); ?>">Referanslar</a></li>
                        <li><a href="<?php echo esc_url(home_url('/iletisim')); ?>">Iletisim</a></li>
                    </ul>
                </div>
            <?php endif; ?>

            <?php if (is_active_sidebar('footer-3')) : ?>
                <?php dynamic_sidebar('footer-3'); ?>
            <?php else : ?>
                <div class="footer-widget">
                    <h3>Urunler</h3>
                    <ul>
                        <li><a href="<?php echo esc_url(home_url('/hizmetler')); ?>">Alarm Sistemleri</a></li>
                        <li><a href="<?php echo esc_url(home_url('/hizmetler')); ?>">Yangin Sistemleri</a></li>
                        <li><a href="<?php echo esc_url(home_url('/hizmetler')); ?>">Gecis Kontrol</a></li>
                        <li><a href="<?php echo esc_url(home_url('/hizmetler')); ?>">Arac Takip</a></li>
                        <li><a href="<?php echo esc_url(home_url('/hizmetler')); ?>">Diyafon & Akilli Ev</a></li>
                        <li><a href="<?php echo esc_url(home_url('/hizmetler')); ?>">Kamera Sistemleri</a></li>
                    </ul>
                </div>
            <?php endif; ?>

            <?php if (is_active_sidebar('footer-4')) : ?>
                <?php dynamic_sidebar('footer-4'); ?>
            <?php else : ?>
                <div class="footer-widget">
                    <h3>Iletisim</h3>
                    <ul>
                        <li>
                            <strong>Telefon:</strong><br>
                            <a href="tel:<?php echo esc_attr(str_replace([' ', '(', ')'], '', get_theme_mod('phone_1', '+905426881924'))); ?>">
                                <?php echo esc_html(get_theme_mod('phone_1', '+90 (542) 688 19 24')); ?>
                            </a><br>
                            <a href="tel:<?php echo esc_attr(str_replace([' ', '(', ')'], '', get_theme_mod('phone_2', '+905496881923'))); ?>">
                                <?php echo esc_html(get_theme_mod('phone_2', '+90 (549) 688 19 23')); ?>
                            </a>
                        </li>
                        <li>
                            <strong>E-posta:</strong><br>
                            <a href="mailto:<?php echo esc_attr(get_theme_mod('email', 'info@vektorguvenliksistemleri.com')); ?>">
                                <?php echo esc_html(get_theme_mod('email', 'info@vektorguvenliksistemleri.com')); ?>
                            </a>
                        </li>
                        <li>
                            <strong>Adres:</strong><br>
                            <?php echo esc_html(get_theme_mod('address', 'Cinarli Mh. Ziyapasa Blv. No:98 Toroman Corner Kat:7/20, Seyhan, Adana')); ?>
                        </li>
                    </ul>
                </div>
            <?php endif; ?>
        </div>

        <div class="footer-bottom">
            <p>&copy; <?php echo date('Y'); ?> Vektor Guvenlik Sistemleri. Tum haklari saklidir.</p>
        </div>
    </div>
</footer>

<!-- Floating WhatsApp Button -->
<a href="https://wa.me/<?php echo esc_attr(get_theme_mod('whatsapp_number', '905426881924')); ?>"
   class="whatsapp-float"
   target="_blank"
   rel="noopener noreferrer">
    <svg viewBox="0 0 24 24" fill="currentColor">
        <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413z"/>
    </svg>
</a>

<?php wp_footer(); ?>
</body>
</html>
