<?php
/**
 * Vektor Guvenlik Sistemleri Theme Functions
 */

// Theme Setup
function vektor_theme_setup() {
    // Add theme support
    add_theme_support('title-tag');
    add_theme_support('post-thumbnails');
    add_theme_support('html5', array('search-form', 'comment-form', 'comment-list', 'gallery', 'caption'));
    add_theme_support('custom-logo');

    // Register Navigation Menus
    register_nav_menus(array(
        'primary' => __('Ana Menu', 'vektor'),
        'footer' => __('Footer Menu', 'vektor'),
    ));

    // Add image sizes
    add_image_size('service-thumb', 400, 300, true);
    add_image_size('blog-thumb', 600, 400, true);
}
add_action('after_setup_theme', 'vektor_theme_setup');

// Register Widget Areas
function vektor_widgets_init() {
    register_sidebar(array(
        'name'          => __('Footer 1', 'vektor'),
        'id'            => 'footer-1',
        'description'   => __('Footer widget area 1', 'vektor'),
        'before_widget' => '<div class="footer-widget">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3>',
        'after_title'   => '</h3>',
    ));

    register_sidebar(array(
        'name'          => __('Footer 2', 'vektor'),
        'id'            => 'footer-2',
        'description'   => __('Footer widget area 2', 'vektor'),
        'before_widget' => '<div class="footer-widget">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3>',
        'after_title'   => '</h3>',
    ));

    register_sidebar(array(
        'name'          => __('Footer 3', 'vektor'),
        'id'            => 'footer-3',
        'description'   => __('Footer widget area 3', 'vektor'),
        'before_widget' => '<div class="footer-widget">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3>',
        'after_title'   => '</h3>',
    ));

    register_sidebar(array(
        'name'          => __('Footer 4', 'vektor'),
        'id'            => 'footer-4',
        'description'   => __('Footer widget area 4', 'vektor'),
        'before_widget' => '<div class="footer-widget">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3>',
        'after_title'   => '</h3>',
    ));
}
add_action('widgets_init', 'vektor_widgets_init');

// Enqueue Scripts and Styles
function vektor_scripts() {
    wp_enqueue_style('vektor-style', get_stylesheet_uri(), array(), '1.0.0');
    wp_enqueue_script('vektor-script', get_template_directory_uri() . '/js/main.js', array(), '1.0.0', true);
}
add_action('wp_enqueue_scripts', 'vektor_scripts');

// Custom Post Type: Services (Hizmetler)
function vektor_custom_post_types() {
    register_post_type('service', array(
        'labels' => array(
            'name' => __('Hizmetler', 'vektor'),
            'singular_name' => __('Hizmet', 'vektor'),
            'add_new' => __('Yeni Ekle', 'vektor'),
            'add_new_item' => __('Yeni Hizmet Ekle', 'vektor'),
            'edit_item' => __('Hizmeti Duzenle', 'vektor'),
            'view_item' => __('Hizmeti Goruntule', 'vektor'),
        ),
        'public' => true,
        'has_archive' => true,
        'supports' => array('title', 'editor', 'thumbnail', 'excerpt'),
        'menu_icon' => 'dashicons-shield-alt',
        'rewrite' => array('slug' => 'hizmetler'),
    ));

    // Custom Post Type: References (Referanslar)
    register_post_type('reference', array(
        'labels' => array(
            'name' => __('Referanslar', 'vektor'),
            'singular_name' => __('Referans', 'vektor'),
            'add_new' => __('Yeni Ekle', 'vektor'),
            'add_new_item' => __('Yeni Referans Ekle', 'vektor'),
            'edit_item' => __('Referansi Duzenle', 'vektor'),
            'view_item' => __('Referansi Goruntule', 'vektor'),
        ),
        'public' => true,
        'has_archive' => true,
        'supports' => array('title', 'thumbnail'),
        'menu_icon' => 'dashicons-awards',
        'rewrite' => array('slug' => 'referanslar'),
    ));
}
add_action('init', 'vektor_custom_post_types');

// Custom Meta Boxes
function vektor_add_meta_boxes() {
    add_meta_box(
        'service_icon',
        __('Hizmet Iconu (Lucide Icon Adi)', 'vektor'),
        'vektor_service_icon_callback',
        'service',
        'side'
    );
}
add_action('add_meta_boxes', 'vektor_add_meta_boxes');

function vektor_service_icon_callback($post) {
    wp_nonce_field('vektor_save_service_icon', 'vektor_service_icon_nonce');
    $icon = get_post_meta($post->ID, '_service_icon', true);
    echo '<input type="text" name="service_icon" value="' . esc_attr($icon) . '" placeholder="Bell, Camera, Lock, etc." style="width:100%">';
    echo '<p style="margin-top:10px;font-size:12px;">Ornekler: Bell, Camera, Lock, Flame, Phone, Car</p>';
}

function vektor_save_service_icon($post_id) {
    if (!isset($_POST['vektor_service_icon_nonce']) || !wp_verify_nonce($_POST['vektor_service_icon_nonce'], 'vektor_save_service_icon')) {
        return;
    }
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }
    if (isset($_POST['service_icon'])) {
        update_post_meta($post_id, '_service_icon', sanitize_text_field($_POST['service_icon']));
    }
}
add_action('save_post', 'vektor_save_service_icon');

// Contact Form Shortcode
function vektor_contact_form_shortcode() {
    ob_start();
    ?>
    <form class="contact-form" method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
        <input type="hidden" name="action" value="vektor_contact_form">
        <?php wp_nonce_field('vektor_contact_form', 'vektor_contact_nonce'); ?>

        <div class="form-group">
            <label>Ad Soyad *</label>
            <input type="text" name="name" required>
        </div>

        <div class="form-group">
            <label>Telefon *</label>
            <input type="tel" name="phone" required>
        </div>

        <div class="form-group">
            <label>E-posta *</label>
            <input type="email" name="email" required>
        </div>

        <div class="form-group">
            <label>Ilgilendiginiz Hizmet</label>
            <select name="service">
                <option value="">Seciniz...</option>
                <option value="Alarm Sistemleri">Alarm Sistemleri</option>
                <option value="Yangin Sistemleri">Yangin Sistemleri</option>
                <option value="Gecis Kontrol">Gecis Kontrol</option>
                <option value="Arac Takip">Arac Takip</option>
                <option value="Diyafon & Akilli Ev">Diyafon & Akilli Ev</option>
                <option value="Kamera Sistemleri">Kamera Sistemleri</option>
            </select>
        </div>

        <div class="form-group">
            <label>Mesajiniz *</label>
            <textarea name="message" required></textarea>
        </div>

        <button type="submit" class="btn btn-primary">Gonder</button>
    </form>
    <?php
    return ob_get_clean();
}
add_shortcode('vektor_contact_form', 'vektor_contact_form_shortcode');

// Handle Contact Form Submission
function vektor_handle_contact_form() {
    if (!isset($_POST['vektor_contact_nonce']) || !wp_verify_nonce($_POST['vektor_contact_nonce'], 'vektor_contact_form')) {
        wp_die('Guvenlik hatasi');
    }

    $name = sanitize_text_field($_POST['name']);
    $phone = sanitize_text_field($_POST['phone']);
    $email = sanitize_email($_POST['email']);
    $service = sanitize_text_field($_POST['service']);
    $message = sanitize_textarea_field($_POST['message']);

    $to = get_option('admin_email');
    $subject = 'Yeni Iletisim Formu - ' . $name;
    $body = "Ad Soyad: $name\n";
    $body .= "Telefon: $phone\n";
    $body .= "E-posta: $email\n";
    $body .= "Hizmet: $service\n\n";
    $body .= "Mesaj:\n$message";

    $headers = array('Content-Type: text/plain; charset=UTF-8');

    if (wp_mail($to, $subject, $body, $headers)) {
        wp_redirect(add_query_arg('contact', 'success', wp_get_referer()));
    } else {
        wp_redirect(add_query_arg('contact', 'error', wp_get_referer()));
    }
    exit;
}
add_action('admin_post_nopriv_vektor_contact_form', 'vektor_handle_contact_form');
add_action('admin_post_vektor_contact_form', 'vektor_handle_contact_form');

// Theme Customizer
function vektor_customize_register($wp_customize) {
    // WhatsApp Number
    $wp_customize->add_section('vektor_contact', array(
        'title' => __('Iletisim Bilgileri', 'vektor'),
        'priority' => 30,
    ));

    $wp_customize->add_setting('whatsapp_number', array(
        'default' => '+905426881924',
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control('whatsapp_number', array(
        'label' => __('WhatsApp Numarasi', 'vektor'),
        'section' => 'vektor_contact',
        'type' => 'text',
    ));

    $wp_customize->add_setting('phone_1', array(
        'default' => '+90 (542) 688 19 24',
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control('phone_1', array(
        'label' => __('Telefon 1', 'vektor'),
        'section' => 'vektor_contact',
        'type' => 'text',
    ));

    $wp_customize->add_setting('phone_2', array(
        'default' => '+90 (549) 688 19 23',
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control('phone_2', array(
        'label' => __('Telefon 2', 'vektor'),
        'section' => 'vektor_contact',
        'type' => 'text',
    ));

    $wp_customize->add_setting('email', array(
        'default' => 'info@vektorguvenliksistemleri.com',
        'sanitize_callback' => 'sanitize_email',
    ));

    $wp_customize->add_control('email', array(
        'label' => __('E-posta', 'vektor'),
        'section' => 'vektor_contact',
        'type' => 'email',
    ));

    $wp_customize->add_setting('address', array(
        'default' => 'Cinarli Mh. Ziyapasa Blv. No:98 Toroman Corner Kat:7/20, Seyhan, Adana',
        'sanitize_callback' => 'sanitize_textarea_field',
    ));

    $wp_customize->add_control('address', array(
        'label' => __('Adres', 'vektor'),
        'section' => 'vektor_contact',
        'type' => 'textarea',
    ));
}
add_action('customize_register', 'vektor_customize_register');

// Excerpt Length
function vektor_excerpt_length($length) {
    return 30;
}
add_filter('excerpt_length', 'vektor_excerpt_length');

// Excerpt More
function vektor_excerpt_more($more) {
    return '...';
}
add_filter('excerpt_more', 'vektor_excerpt_more');
