<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

<header class="site-header">
    <div class="container">
        <div class="site-logo">
            <?php
            if (has_custom_logo()) {
                the_custom_logo();
            } else {
                ?>
                <a href="<?php echo esc_url(home_url('/')); ?>" class="logo-link">
                    <h1 style="color: #dc2626; font-size: 24px; font-weight: bold; line-height: 1.2; margin: 0;">
                        VEKTOR
                    </h1>
                    <span style="font-size: 12px; font-weight: normal; color: #666; display: block;">Güvenlik Sistemleri</span>
                </a>
                <?php
            }
            ?>
        </div>

        <nav class="main-navigation">
            <?php
            wp_nav_menu(array(
                'theme_location' => 'primary',
                'menu_class' => 'nav-menu',
                'container' => false,
                'fallback_cb' => function() {
                    echo '<ul class="nav-menu">';
                    echo '<li><a href="' . esc_url(home_url('/')) . '">Ana Sayfa</a></li>';
                    echo '<li><a href="' . esc_url(home_url('/hizmetler')) . '">Ürünler</a></li>';
                    echo '<li><a href="' . esc_url(home_url('/blog')) . '">Blog</a></li>';
                    echo '<li><a href="' . esc_url(home_url('/hakkimizda')) . '">Hakkımızda</a></li>';
                    echo '<li><a href="' . esc_url(home_url('/referanslar')) . '">Referanslar</a></li>';
                    echo '<li><a href="' . esc_url(home_url('/iletisim')) . '">İletişim</a></li>';
                    echo '</ul>';
                }
            ));
            ?>
        </nav>
    </div>
</header>
