<?php get_header(); ?>

<div class="hero-section" style="background-image: url('https://images.pexels.com/photos/430208/pexels-photo-430208.jpeg?auto=compress&cs=tinysrgb&w=1920');">
    <div class="container">
        <div class="hero-content">
            <div class="hero-logo">
                <h1 style="color: #dc2626; font-size: 36px; font-weight: bold; margin-bottom: 10px;">
                    VEKTOR
                </h1>
                <p style="font-size: 14px; color: #e5e7eb; margin-bottom: 30px;">Güvenlik Sistemleri</p>
            </div>
            <h2 class="hero-title">Güvenliğiniz, Bizim <span class="highlight">Önceliğimiz</span></h2>
            <p class="hero-subtitle">7/24 kesintisiz güvenlik çözümleriyle eviniz ve işyeriniz her zaman güvende</p>
            <div class="hero-buttons">
                <a href="<?php echo esc_url(home_url('/hizmetler')); ?>" class="btn btn-primary">Ürünleri İncele</a>
                <a href="<?php echo esc_url(home_url('/iletisim')); ?>" class="btn btn-secondary">İletişime Geç</a>
            </div>
        </div>
    </div>
</div>

<div class="services-section">
    <div class="container">
        <div class="section-title">
            <h2>Ürün Kategorilerimiz</h2>
            <p>Güvenlik ihtiyaçlarınıza özel profesyonel çözümler</p>
        </div>

        <div class="services-grid">
            <?php
            $services_args = array(
                'post_type' => 'service',
                'posts_per_page' => 6,
            );
            $services_query = new WP_Query($services_args);

            if ($services_query->have_posts()) :
                while ($services_query->have_posts()) : $services_query->the_post();
                    ?>
                    <a href="<?php the_permalink(); ?>" class="service-card">
                        <div class="service-card-image">
                            <?php
                            if (has_post_thumbnail()) {
                                the_post_thumbnail('service-thumb');
                            } else {
                                echo '<img src="https://images.pexels.com/photos/60504/security-protection-anti-virus-software-60504.jpeg?auto=compress&cs=tinysrgb&w=400" alt="' . get_the_title() . '">';
                            }
                            ?>
                        </div>
                        <div class="service-card-content">
                            <h3><?php the_title(); ?></h3>
                            <p><?php echo wp_trim_words(get_the_excerpt(), 15); ?></p>
                        </div>
                    </a>
                    <?php
                endwhile;
                wp_reset_postdata();
            else :
                // Fallback default services
                $default_services = array(
                    array(
                        'title' => 'Alarm Sistemleri',
                        'desc' => 'Kablolu, kablosuz ve hibrit alarm çözümleri',
                        'img' => 'https://images.pexels.com/photos/60504/security-protection-anti-virus-software-60504.jpeg?auto=compress&cs=tinysrgb&w=400',
                        'icon' => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M6 8a6 6 0 0 1 12 0c0 7 3 9 3 9H3s3-2 3-9"></path><path d="M10.3 21a1.94 1.94 0 0 0 3.4 0"></path></svg>'
                    ),
                    array(
                        'title' => 'Yangın Sistemleri',
                        'desc' => 'Adresli ve konvansiyonel yangın alarm sistemleri',
                        'img' => 'https://images.pexels.com/photos/189474/pexels-photo-189474.jpeg?auto=compress&cs=tinysrgb&w=400',
                        'icon' => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M8.5 14.5A2.5 2.5 0 0 0 11 12c0-1.38-.5-2-1-3-1.072-2.143-.224-4.054 2-6 .5 2.5 2 4.9 4 6.5 2 1.6 3 3.5 3 5.5a7 7 0 1 1-14 0c0-1.153.433-2.294 1-3a2.5 2.5 0 0 0 2.5 2.5z"></path></svg>'
                    ),
                    array(
                        'title' => 'Geçiş Kontrol',
                        'desc' => 'Biyometrik ve kartlı geçiş kontrol sistemleri',
                        'img' => 'https://images.pexels.com/photos/279810/pexels-photo-279810.jpeg?auto=compress&cs=tinysrgb&w=400',
                        'icon' => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect width="18" height="11" x="3" y="11" rx="2" ry="2"></rect><path d="M7 11V7a5 5 0 0 1 10 0v4"></path></svg>'
                    ),
                    array(
                        'title' => 'Araç Takip',
                        'desc' => 'GPS tabanlı araç takip ve filo yönetimi',
                        'img' => 'https://images.pexels.com/photos/3806753/pexels-photo-3806753.jpeg?auto=compress&cs=tinysrgb&w=400',
                        'icon' => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M19 17h2c.6 0 1-.4 1-1v-3c0-.9-.7-1.7-1.5-1.9C18.7 10.6 16 10 16 10s-1.3-1.4-2.2-2.3c-.5-.4-1.1-.7-1.8-.7H5c-.6 0-1.1.4-1.4.9l-1.4 2.9A3.7 3.7 0 0 0 2 12v4c0 .6.4 1 1 1h2"></path><circle cx="7" cy="17" r="2"></circle><path d="M9 17h6"></path><circle cx="17" cy="17" r="2"></circle></svg>'
                    ),
                    array(
                        'title' => 'Diyafon & Akıllı Ev',
                        'desc' => 'Apartman, villa diyafon ve otomasyon sistemleri',
                        'img' => 'https://images.pexels.com/photos/1115804/pexels-photo-1115804.jpeg?auto=compress&cs=tinysrgb&w=400',
                        'icon' => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z"></path></svg>'
                    ),
                    array(
                        'title' => 'Kamera Sistemleri',
                        'desc' => 'IP, analog ve termal güvenlik kameraları',
                        'img' => 'https://images.pexels.com/photos/430208/pexels-photo-430208.jpeg?auto=compress&cs=tinysrgb&w=400',
                        'icon' => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="m23 7-7 5 7 5V7z"></path><rect width="15" height="14" x="1" y="5" rx="2" ry="2"></rect></svg>'
                    ),
                );

                foreach ($default_services as $service) :
                    ?>
                    <div class="service-card">
                        <div class="service-card-image">
                            <img src="<?php echo esc_url($service['img']); ?>" alt="<?php echo esc_attr($service['title']); ?>">
                            <div class="service-card-overlay"></div>
                            <div class="service-card-icon">
                                <?php echo $service['icon']; ?>
                            </div>
                        </div>
                        <div class="service-card-content">
                            <h3><?php echo esc_html($service['title']); ?></h3>
                            <p><?php echo esc_html($service['desc']); ?></p>
                        </div>
                    </div>
                    <?php
                endforeach;
            endif;
            ?>
        </div>
    </div>
</div>

<div class="stats-section">
    <div class="container">
        <div class="stats-grid">
            <div class="stat-item">
                <h3>8+</h3>
                <p>Yıllık Tecrübe</p>
            </div>
            <div class="stat-item">
                <h3>1000+</h3>
                <p>Takip Edilen Araç</p>
            </div>
            <div class="stat-item">
                <h3>7/24</h3>
                <p>Teknik Destek</p>
            </div>
            <div class="stat-item">
                <h3>3</h3>
                <p>Hizmet Bölgesi</p>
            </div>
        </div>
    </div>
</div>

<div class="container">
    <div class="cta-section">
        <div class="cta-bg-overlay"></div>
        <div class="cta-content">
            <h2>Ücretsiz Keşif ve Danışmanlık</h2>
            <p>Profesyonel ekibimiz güvenlik ihtiyaçlarınızı yerinde inceleyerek size en uygun çözümleri sunar.</p>
            <a href="<?php echo esc_url(home_url('/iletisim')); ?>" class="btn btn-cta">Hemen İletişime Geçin</a>
        </div>
    </div>
</div>

<?php get_footer(); ?>
