<?php
/*
Template Name: Iletisim Sayfasi
*/
get_header();
?>

<div style="padding-top: 100px; padding-bottom: 60px;">
    <div class="container">
        <div class="section-title">
            <h1>Iletisim</h1>
            <p>Sizlere nasil yardimci olabiliriz?</p>
        </div>

        <?php if (isset($_GET['contact']) && $_GET['contact'] === 'success') : ?>
            <div style="background: #d4edda; color: #155724; padding: 20px; border-radius: 8px; margin-bottom: 30px; text-align: center;">
                Mesajiniz basariyla gonderildi! En kisa surede size donecegiz.
            </div>
        <?php elseif (isset($_GET['contact']) && $_GET['contact'] === 'error') : ?>
            <div style="background: #f8d7da; color: #721c24; padding: 20px; border-radius: 8px; margin-bottom: 30px; text-align: center;">
                Bir hata olustu. Lutfen tekrar deneyin veya telefon ile iletisime gecin.
            </div>
        <?php endif; ?>

        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 40px; margin-bottom: 60px;">
            <div>
                <h2 style="margin-bottom: 20px;">Bize Ulasin</h2>
                <?php echo do_shortcode('[vektor_contact_form]'); ?>
            </div>

            <div>
                <h2 style="margin-bottom: 20px;">Iletisim Bilgileri</h2>
                <div style="background: #f9fafb; padding: 30px; border-radius: 12px;">
                    <div style="margin-bottom: 25px;">
                        <h3 style="color: #dc2626; margin-bottom: 10px;">Telefon</h3>
                        <p>
                            <a href="tel:<?php echo esc_attr(str_replace([' ', '(', ')'], '', get_theme_mod('phone_1', '+905426881924'))); ?>">
                                <?php echo esc_html(get_theme_mod('phone_1', '+90 (542) 688 19 24')); ?>
                            </a><br>
                            <a href="tel:<?php echo esc_attr(str_replace([' ', '(', ')'], '', get_theme_mod('phone_2', '+905496881923'))); ?>">
                                <?php echo esc_html(get_theme_mod('phone_2', '+90 (549) 688 19 23')); ?>
                            </a>
                        </p>
                    </div>

                    <div style="margin-bottom: 25px;">
                        <h3 style="color: #dc2626; margin-bottom: 10px;">E-posta</h3>
                        <p>
                            <a href="mailto:<?php echo esc_attr(get_theme_mod('email', 'info@vektorguvenliksistemleri.com')); ?>">
                                <?php echo esc_html(get_theme_mod('email', 'info@vektorguvenliksistemleri.com')); ?>
                            </a>
                        </p>
                    </div>

                    <div>
                        <h3 style="color: #dc2626; margin-bottom: 10px;">Adres</h3>
                        <p><?php echo esc_html(get_theme_mod('address', 'Cinarli Mh. Ziyapasa Blv. No:98 Toroman Corner Kat:7/20, Seyhan, Adana')); ?></p>
                    </div>

                    <div style="margin-top: 30px;">
                        <h3 style="color: #dc2626; margin-bottom: 15px;">Sosyal Medya</h3>
                        <div style="display: flex; gap: 15px;">
                            <a href="https://wa.me/<?php echo esc_attr(get_theme_mod('whatsapp_number', '905426881924')); ?>"
                               target="_blank"
                               style="display: inline-flex; align-items: center; justify-content: center; width: 45px; height: 45px; background: #25d366; border-radius: 50%; color: white;">
                                <svg viewBox="0 0 24 24" fill="currentColor" style="width:24px;height:24px">
                                    <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413z"/>
                                </svg>
                            </a>
                            <a href="https://instagram.com/vektorguvenliksistemleri"
                               target="_blank"
                               style="display: inline-flex; align-items: center; justify-content: center; width: 45px; height: 45px; background: #E4405F; border-radius: 50%; color: white;">
                                <svg viewBox="0 0 24 24" fill="currentColor" style="width:24px;height:24px">
                                    <path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zM12 0C8.741 0 8.333.014 7.053.072 2.695.272.273 2.69.073 7.052.014 8.333 0 8.741 0 12c0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98C8.333 23.986 8.741 24 12 24c3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98C15.668.014 15.259 0 12 0zm0 5.838a6.162 6.162 0 100 12.324 6.162 6.162 0 000-12.324zM12 16a4 4 0 110-8 4 4 0 010 8zm6.406-11.845a1.44 1.44 0 100 2.881 1.44 1.44 0 000-2.881z"/>
                                </svg>
                            </a>
                            <a href="https://facebook.com/vektorguvenliksistemleri"
                               target="_blank"
                               style="display: inline-flex; align-items: center; justify-content: center; width: 45px; height: 45px; background: #1877F2; border-radius: 50%; color: white;">
                                <svg viewBox="0 0 24 24" fill="currentColor" style="width:24px;height:24px">
                                    <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div style="height: 400px; border-radius: 12px; overflow: hidden; box-shadow: 0 4px 20px rgba(0,0,0,0.1);">
            <iframe
                src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3186.123!2d35.321!3d36.987!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x0!2zMzbCsDU5JzEzLjIiTiAzNcKwMTknMTUuNiJF!5e0!3m2!1str!2str!4v1234567890"
                width="100%"
                height="100%"
                style="border:0;"
                allowfullscreen=""
                loading="lazy"
                referrerpolicy="no-referrer-when-downgrade">
            </iframe>
        </div>
    </div>
</div>

<?php get_footer(); ?>
