<?php get_header(); ?>

<div style="padding-top: 100px; padding-bottom: 60px;">
    <div class="container">
        <?php
        while (have_posts()) : the_post();
            ?>
            <article style="max-width: 900px; margin: 0 auto;">
                <?php if (has_post_thumbnail()) : ?>
                    <div style="margin-bottom: 30px; border-radius: 12px; overflow: hidden;">
                        <?php the_post_thumbnail('large', array('style' => 'width: 100%; height: auto;')); ?>
                    </div>
                <?php endif; ?>

                <div class="blog-meta" style="margin-bottom: 20px;">
                    <span><?php echo get_the_date(); ?></span>
                    <span>|</span>
                    <span><?php the_category(', '); ?></span>
                    <span>|</span>
                    <span><?php echo get_post_meta(get_the_ID(), '_view_count', true) ?: 0; ?> goruntulenme</span>
                </div>

                <h1 style="font-size: 2.5rem; margin-bottom: 30px; color: #333;">
                    <?php the_title(); ?>
                </h1>

                <div style="line-height: 1.8; font-size: 1.1rem; color: #555;">
                    <?php the_content(); ?>
                </div>

                <?php if (get_the_tags()) : ?>
                    <div style="margin-top: 40px; padding-top: 20px; border-top: 1px solid #eee;">
                        <strong>Etiketler: </strong>
                        <?php the_tags('', ', ', ''); ?>
                    </div>
                <?php endif; ?>

                <div style="margin-top: 40px;">
                    <a href="<?php echo esc_url(home_url('/blog')); ?>" class="btn btn-secondary">← Blog'a Don</a>
                </div>
            </article>
            <?php
        endwhile;
        ?>
    </div>
</div>

<?php get_footer(); ?>
